package com.rocogz.merchant.entity.store;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDate;

/**
 * <p>
 * 商户营业时间段
 * </p>
 *
 * @author liangyongtong
 * @since 2020-04-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MerchantStoreBusinessSection extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 商户编码
     */
    private String storeCode;

    /**
     * 营业类型
     */
    private String businessType;

    /**
     * 日期
     */
    private LocalDate dateSection;

    /**
     * 星期几
     */
    private Integer weeks;

    /**
     * 几号:注意月份，是否润年
     */
    private Integer days;


}
