package com.rocogz.merchant.entity.agent.goods;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 代理商产品信息表
 * </p>
 *
 * @author djt
 * @since 2020-12-16
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class MerchantAgentGoods extends IdEntity {


    /**
     * 代理商产品编号
     */
    private String code;

    /**
     * 代理商产品名称
     */
    private String name;

    /**
     * 平台产品编号(merchant_goods.code)
     */
    private String merchantGoodsCode;

    /**
     * 代理商产品编号(merchant_agent.code)
     */
    private String agentCode;

    /**
     * 采购性质
     */
    private String purchaseWay;

    /**
     * 代理商采购价
     */
    private BigDecimal purchasePrice;

    /**
     * 代理商市场价
     */
    private BigDecimal marketPrice;

    /**
     * 代理商产品说明
     */
    private String introduce;

    /**
     * 上下架状态
     */
    private String status;

    /**
     * 创建人id
     */
    private Integer createUser;

    /**
     * 创建人名称
     */
    private String createUserName;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新人id
     */
    private Integer updateUser;

    /**
     * 更新人名称
     */
    private String updateUserName;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 建议兑换积分值
     */
    private BigDecimal suggestExchangePointValue;
}
