package com.rocogz.merchant.dto.bAgent.goods;

import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

import static com.rocogz.merchant.constant.Constant.DictData.GOODS_NATURE_PLATFORM_MEAL;
import static com.rocogz.merchant.constant.Constant.DictData.GOODS_NATURE_SUPPLIER_MEAL;

/**
 * <dl>
 * <dd>Description:B端代理人商品 </dd>
 * <dd>@date: 2021/05/24</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Setter
@Getter
@Accessors(chain = true)
public class BAgentProductResponseDto {
    /**
     * 产品名称
     */
    private String goodsName;

    //代理人勾选中的 客户产品编号/代理商产品编号/平台产品编码(如果是套餐子项)
    private String goodsCode;

    /**
     * 平台产品编码
     */
    private String platformGoodsCode;

    /**
     * 勾选中的产品的 产品类型
     *
     * @see MerchantGoods#goodsType
     * @see Constant.DictData#PRODUCT_TYPE_OIL_CARD_DIGITAL_YES
     */
    private String goodsType;

    /**
     * 图片
     */
    private String listView;

    /**
     * 卡券左上角标签
     */
    private String cardCouponLeftCornerLabel;

    /**
     * 卡券金额下方注释内容
     */
    private String cardCouponNotes;

    /**
     * 使用说明，因套餐项取得使用说明是基础商品信息里的。基础信息中的introduce是个富文本，不太适合
     * 暂时对于套餐项不赋值。
     */
    private String introduce;

    /**
     * 成本价
     */
    private BigDecimal costPrice;

    /**
     * 市场价，换成了平台产品的市场价
     */
    private BigDecimal marketPrice;

    /**
     * 产品内容
     */
    private String goodsContent;

    /**
     * 产品性质 单品，平台订单套餐，供应商定制套餐
     */
    private String goodsNature;


    /**
     * 套餐项商品的组成数量 例如 代驾券2张
     */
    private Integer composeNum;

    /**
     * 套餐子项商品
     */
    List<BAgentProductResponseDto> suitItems ;



}
