package com.rocogz.merchant.entity.goods;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 商户修改操作日志
 * </p>
 *
 * @author yinshihao
 * @since 2020-06-16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MerchantGoodsLog extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 商品编码
     */
    private String goodsCode;

    /**
     * 操作项
     */
    private String logType;

    /**
     * 信息
     */
    private String logContent;

    /**
     * 操作人
     */
    private String logUser;

    /**
     * 操作时间
     */
    private LocalDateTime logTime;


}
