package com.rocogz.merchant.dto.goods;

import com.rocogz.merchant.pager.Sort;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.autoconfigure.data.web.SpringDataWebProperties;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * <dl>
 * <dd>Description:库存分页查询请求参数</dd>
 * <dd>@date: 2020/08/14</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Getter
@Setter
@Builder
public class GoodsStockPageRequestDto {

    /**
     * 商品编码
     */
    private String goodsCode;
    /**
     * 商户名称
     */
    private String goodsName;
    /**
     * 品牌编码
     */
    private String brandCode;
    /**
     * 商品分类编码
     */
    private String goodsClassificationCode;
    /**
     * 供应商编码
     */
    private String supplierCode;

    /**
     * 供应商编码集合
     */
    private List<String> supplierCodeList;
    /**
     * 排序
     */
    private Sort sort;

    /**
     *  每页多少条
     */
    private int limit;
    /**
     * 第几页
     */
    private int page;
}
