package com.rocogz.merchant.entity.scm;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.merchant.constant.Constant;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 订单远程调用日志表
 * </p>
 *
 * @author yinshihao
 * @since 2021-03-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantScmOrderRemoteLog extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 日志类型
     */
    private String logType;

    /**
     * 请求报文
     */
    private String reqText;

    /**
     * 请求时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    private LocalDateTime reqTime;

    /**
     * 响应报文
     */
    private String resText;

    /**
     * 响应时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    private LocalDateTime resTime;

    /**
     * 耗时
     */
    private String elapsedSeconds;

    /**
     * 操作人名字
     */
    private String createUser;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    private LocalDateTime createTime;

    /**
     * 备注
     */
    private String remark;

    /**
     * 状态
     */
    private String status;

    /**
     * 日志订单类型: DOWN 下游订单 UP 上游订单
     * @see Constant.DictData#ORDER_LOG_ORDER_TYPE_DOWN
     */
    private String orderType;
}
