package com.rocogz.merchant.entity.agent;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <p>
 *  代理商
 * </p>
 *
 * @author yinshihao
 * @since 2020-12-15
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantAgent extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 代理商编码
     */
    private String code;

    /**
     * 代理商名称
     */
    private String name;

    /**
     * 省名称
     */
    private String provinceName;

    /**
     * 省编码
     */
    private String provinceCode;

    /**
     * 市名称
     */
    private String cityName;

    /**
     * 市编码
     */
    private String cityCode;

    /**
     * 区名称
     */
    private String districtName;

    /**
     * 区编码
     */
    private String districtCode;

    /**
     * 详细地址
     */
    private String detailAddress;

    /**
     * 营业执照名称
     */
    private String businessLicenseName;

    /**
     * 法人代表名称
     */
    private String legalPersonName;

    /**
     * 营业执照号
     */
    private String businessLicenseNo;

    /**
     * 营业执照图片
     */
    private String businessLicensePhoto;

    /**
     * 代理商介绍
     */
    private String introduce;

    /**
     * 状态
     */
    private String status;

    /**
     * 代理商联系人列表
     */
    @TableField(exist = false)
    private List<MerchantAgentContacts> agentContacts;
}
