package com.rocogz.merchant.dto.scm;

import com.rocogz.merchant.entity.scm.MerchantScmInformation;
import com.rocogz.merchant.entity.scm.MerchantScmOrderComboDetail;
import com.rocogz.merchant.entity.scm.MerchantScmProductInformation;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @author zhangmin
 * 此实体类对应于 消息中的 com.rocogz.syy.equity.dto.equity.userCoupon.SendMessageForGrantUserCouponDto
 * 整个订单的用户券发送成功后, 发送短信到mq
 */
@Setter @Getter
@Accessors(chain = true)
public class UserCouponNotificationSmsMsgDto {

    /**
     * 发送人,操作人
     */
    private String sendCode;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 证件类型
     */
    private String idType;

    /**
     * 证件号码
     */
    private String idCardExplicit;


    /**
     * 发放主体
     */
    private String sourceCode;

    /**
     * 平台ID
     */
    private String miniAppid;

    /**
     * 礼包名称,写死 "保险服务大礼包"
     */
    private String giftName;

    /**
     * 面值
     */
    private String facevalue;


    /**
     * 申请单号
     * @see MerchantScmInformation#applyNo
     */
    private String parentBizCode;

    /**
     * 清单编号,业务单号
     * @see MerchantScmInformation#businessCode
     */
    private String bizCode;

    /**
     * 执行时间,可以为null
     */
    private LocalDateTime executeTime;

    /**
     * 截止日期
     */
    private LocalDate invalidDate;
}
