package com.rocogz.merchant.entity.evaluate;

import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 订单评价数量汇总
 * </p>
 *
 * @author liangyongtong
 * @since 2020-05-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantEvaluateKpi extends IdEntity {

    private static final long serialVersionUID = 2786182130296523445L;
    /**
     * 商户服务项目编码
     */
    private String storeServiceCode;

    /**
     * 印象标签名称
     */
    private String impressionLabel;

    /**
     * 商户服务项目统计数量
     */
    private Integer amount;

    /**
     * 精选商户服务项目统计数量
     */
    private Integer perfectAmount;

    /**
     * 商户编码
     */
    private String storeCode;

    /**
     * 专区服务项目编码
     */
    private String areaServiceCode;

    /**
     * 专区编码
     */
    private String areaCode;
}
