package com.rocogz.merchant.entity.service;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;

import java.util.List;

/**
 * <p>
 * 商户服务-服务分类表
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-04-03
 */
@TableName("merchant_service_classification")
@Data
public class ServiceClassification extends UserTimeEntity {

    private static final long serialVersionUID = -1606396307951548729L;
    /**
     * 父级服务分类编码,父级服务分类编码为0的为顶级
     */
    private String parentCode;

    /**
     * 服务分类编码
     */
    private String code;

    /**
     * 服务分类名称
     */
    private String name;

    /**
     * 服务分类名称
     */
    private String photoPath;

    /**
     * 服务分类名称
     */
    @TableField(exist = false)
    private List<String> industryCodeList;

    /**
     * 服务分类说明
     */
    private String description;
}
