package com.rocogz.merchant.dto.scm.order;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

/**
 * @author zhangmin
 */
@Setter @Getter @Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public abstract class ScmOrderSettleBaseDto<ITEM extends SettleReceiptItem> {

    /**
     * 发放主体编号
     */
    @Deprecated
    private String issuingBodyCode;

    /**
     * 发放主体的：所属结算单位
     */
    private String belongSettlementUnit;

    /**
     * 代理商编号
     */
    private String  agentCode;

    /**
     * 处理批次号
     */
    private String batchCode;

    /**
     * 需要结算的收款单列表 或 每个收款单的处理结果
     */
    protected List<ITEM> receiptItemList;


    /**
     * 获取需要结算总金额合计
     */
    @JsonIgnore
    public BigDecimal getTotalAmountSum() {
        if(CollectionUtils.isEmpty(receiptItemList)) {
            return BigDecimal.ZERO;
        }

        BigDecimal sum = receiptItemList.stream().map(SettleReceiptItem::getTotalAmount).reduce(BigDecimal.ZERO,(a,b)->a.add(b));
        return sum.setScale(3,RoundingMode.HALF_UP);
    }



}
