package com.rocogz.merchant.response.agent.goods;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.merchant.entity.agent.goods.MerchantAgentGoods;
import lombok.Data;

import java.math.BigDecimal;

/**
 *代理商产品列表实体类
 * @author djt
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class MerchantAgentGoodsListResp extends MerchantAgentGoods {

    /**
     * 平台产品状态
     */
    private String merchantGoodsStatus;

    /**
     *代理商简称
     */
    private String agentName;


    /**
     *列表图:路径可能会被分割成几个对应比列的图
     */
    private String listView;


    /**
     * 平台产品商品名称
     */
    private String merchantGoodsName;

    /**
     * 平台产品商品简称
     */
    private String merchantGoodsAbbreviation;

    /**
     * 产品类型编码
     */
    private String goodsClassificationCode;

    /**
     * 产品类型编码
     */
    private String goodsClassificationName;

    /**
     * 供应商名称
     */
    private String supplierName;

    /**
     * 供应商编码
     */
    private String supplierCode;


    /**
     * 品牌名称
     */
    private String brandName;

    /**
     * 品牌名称
     */
    private String brandCode;

    /**
     * 代理商产品类型
     */
    private String goodsType;

    /**
     * 平台产品市场价
     */
    private String merchantGoodsMarketPrice;

    /**
     * 供应商产品编号
     */
    private String supplierGoodsCode;

    /**
     * 供应商产品名称
     */
    private String supplierGoodsName;

    /**
     * 平台产品类型
     */
    private String productTypeName;

    /**
     * 模型
     */
    private String model;

    /**
     * 平台产品的内容
     */
    private String goodsContent;


    /**
     * 卡券左上角标签
     */
    private String cardCouponLeftCornerLabel;

    /**
     * 卡券金额下方注释内容
     */
    private String cardCouponNotes;

    /**
     * 产品性质
     */
    private String goodsNature;


    /**
     * 如果是套餐,包含的套餐子项个数
     */
    private int suitItemCount;


    private BigDecimal suggestExchangePointValue;

}
