package com.rocogz.merchant.client.scm.intfc;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.Max;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author 尹世豪
 * @Description:
 * @Package com.rocogz.dto.dingju.response.token
 * @date 2020/11/16 8:54
 * @Copyright © 广州大诚若谷信息科技有限公司
 */
@Data
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class WxOrderReqDto extends BaseConfigReqDto {

    /**
     * 权益编号
     */
    @NotBlank(message = "权益编号不能为空")
    private String pwNo;

    /**
     * 手机号,即充值手机号
     */
    @NotBlank(message = "手机号不能为空")
    private String phone;

    /**
     * 商户订单号
     */
    @NotBlank(message = "商户订单号不能为空")
    private String outOrderId;

    /**
     * 充值面额
     */
    @NotNull(message = "充值面额不能为空")
    @Max(1000)
    private Integer itemFacePrice;

    /**
     * 微信流水号
     */
    @NotBlank(message = "微信流水号不能为空")
    private String wxTradeNo;

    /**
     * 微信支付金额
     */
    @NotBlank(message = "微信支付金额不能为空")
    private String wxPayAmount;

    /**
     * 回调URL
     */
    private String notifyUrl;
}
