package com.rocogz.merchant.dto.customer.goods;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * <dl>
 * <dd>Description:保存发放主体选择的合作客户产品 </dd>
 * <dd>@date: 2021/11/11</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
public class IssuingBodyCustomerGoodsSaveReq {

    /**
     * 发放主体编码
     */
    @NotBlank
    private String issuingBodyCode;

    /**
     * 发放主体姓名
     */
    @NotBlank
    private String customerCode;

    /**
     * 创建人
     */
    @NotBlank
    private String createUser;

    /**
     * 合作客户产品的codeList
     */
    private List<String> customerGoodsCodeList;



}
