package com.rocogz.merchant.dto.scm;

import com.rocogz.merchant.entity.scm.MerchantScmInformation;
import com.rocogz.merchant.entity.scm.MerchantScmOrderInformation;
import com.rocogz.merchant.entity.scm.MerchantScmProductInformation;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDate;

/**
 * @author zhangmin
 * 整个订单的用户券发送成功后, 发送 "更新清单状态+申请单产品发放数量" 消息到mq
 */
@Setter
@Getter
@Accessors(chain = true)
public class UpdateUserCouponApplyStatusMsgDto {

    /**
     * 清单编号,业务单号
     *
     * @see MerchantScmInformation#businessCode
     */
    private String bizCode;


    /**
     * 发放数量
     *
     * @see MerchantScmOrderInformation#quantity
     */
    private Integer grantQuantity;

    /**
     * 平台产品编号
     *
     * @see MerchantScmProductInformation#productCode
     */
    private String productCode;

    /**
     * 发放主体编号
     */
    private String sourceCode;

    /**
     * 团队编号
     */
    private String teamCode;

    /**
     * 领取失效日期
     */
    private LocalDate receiveInvalidDate;
}
