package com.rocogz.merchant.dto.scmWarehouse.stock;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <dl>
 * <dd>Description:批量出入库请求 </dd>
 * <dd>@date: 2022/03/13</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class ScmGoodsBatchManualOutInReq {

    /**
     * 仓库编码
     */
    @NotBlank
    private String whCode;

    /**
     * 操作人
     */
    @NotBlank
    private String operator;

    /**
     * 操作的产品
     */
    @Valid
    @NotEmpty
    private List<ScmGoodsBatchManualOutInItemDto> goodsList;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;
    /**
     * 备注
     */
    private String remark ;
}
