package com.rocogz.merchant.dto.scmWarehouse.stock;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <dl>
 * <dd>Description:库存解冻请求 </dd>
 * <dd>@date: 2022/03/09</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class ScmGoodsStockUnFrozenReq {

    /**
     * 发放主体编号，可以作为分布式锁
     */
    @NotBlank
    private String issuingBodyCode;

    /**
     * 操作人人
     */
    @NotBlank
    private String operator;

    /**
     * 解冻的产品列表
     */
    @Valid
    @NotEmpty
    private List<ScmGoodsStockUnFrozenItemDto> goodsList;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

}
