package com.rocogz.merchant.dto.scmWarehouse.stock;

import lombok.Data;

/**
 * <dl>
 * <dd>Description:库存流搜索 </dd>
 * <dd>@date: 2022/03/13</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
public class ScmStockFlowSearchReq {

    /**
     * 仓库编号
     */
    private String whCode;

    /**
     * 仓库产品编号
     */
    private String whGoodsCode;

    /**
     * 业务单号
     */
    private String bizNo;

    /**
     * 库存的流水号
     */
    private String flowCode;

    /**
     * 当前阶段
     */
    private String stage;

    /**
     * 分页
     */
    private Integer limit = 20;
    /**
     * 当前第几页
     */
    private Integer page = 1;

    /**
     * True 表示不分页时，分页条件不启作用
     */
    private Boolean noPage = Boolean.FALSE;

}
