package com.rocogz.merchant.dto.scmWarehouse.stock;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description:库存的调拨保存请求</dd>
 * <dd>@date: 2022/03/09</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class ScmGoodsStockAllocateSaveReq {

    /**
     * 出库仓库编号
     */
    @NotBlank
    private String outWhCode;

    /**
     * 入库仓库编号
     */
    @NotBlank
    private String inWhCode;

    /**
     * 入库商品编号
     */
    @NotBlank
    private String inGoodsCode;

    /**
     * 出库商品编号
     */
    @NotBlank
    private String outGoodsCode;

    /**
     * 操作的数量
     */
    @Min(1)
    @NotNull
    private Integer quantity ;

    /**
     * 备注
     */
    private String remark;

    /**
     * 操作人
     */
    @NotBlank
    private String operator;
    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

}
