package com.rocogz.merchant.entity.scm;


import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 修复上游订单使用有效期
 * @author zhangmin
 */
@Setter @Getter
public class MerchantScmFixOrderDetailValidity extends IdEntity {

    private Integer orderItemId;

    private String orderCode;

    private String orderItemCode;

    private BigDecimal platProdMarketPrice;

    private BigDecimal platProdPurchasePrice;

    /**
     * 平台产品编号
     */
    private String productCode;

    private String productType;

    //单品，供应商套餐，平台自定义套餐
    private String goodsNature;

    /**
     * 合作客户产品
     */
    private String customerProductCode;

    /**
     * 服务商产品
     */
    private String agentProductCode;

    /**
     * @see MerchantScmInformation#sourceCode
     */
    private String issuingBodyCode;

    /**
     * @see MerchantScmOrderInformation#orderType
     */
    private String orderType;

    private LocalDateTime grantTime;

    private LocalDateTime receiveTime;

    /**
     * 未处理、已处理、处理中、处理失败
     * @see Constant.DictData#COVER_DATA_STATUS_UNPROCESSED
     */
    private String status;

    /**
     * 处理失败原因
     */
    private String failReason;

    private LocalDateTime updateTime;


    @JsonIgnoreProperties
    public String getConfigRuleProductCode() {
        if(StringUtils.isNotBlank(customerProductCode)) {
            return customerProductCode;
        }

        return agentProductCode;
    }

}
