package com.rocogz.merchant.entity.scmWarehouse;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.merchant.constant.ScmWarehouseConstant;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description:库存流日志 </dd>
 * <dd>@date: 2022/03/09</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantScmStockFlowLog extends IdEntity {

    private static final long serialVersionUID=1L;
    /**
     * 库存流
     */
    private String flowCode;
    /**
     * 业务单号:清单编号/兑换订单编号，调拨申请单号
     */
    private String bizNo;
    /**
     * 仓库编号
     */
    private String whCode;

    /**
     * 仓库名称
     */
    @TableField(exist = false)
    private String whName;

    /**
     * 仓库类型
     */
    @TableField(exist = false)
    private String whType;

    /**
     * 实际操作中的仓库产品编号
     */
    private String whGoodsCode;

    /**
     * 实际操作中的仓库产品名称
     */
    @TableField(exist = false)
    private String whGoodsName;

    /**
     * 操作类型
     * 冻结库存,解冻库存,占用库存,取消库存,出库扣减，
     * 调拨入库,调拨出库,
     * 手动增加库存,手动减少库存
     * @see ScmWarehouseConstant.DictScmStockFlowLogOperateType#TYPE_CODE
     */
    private String operateType;

    /**
     * 数量
     */
    private Integer quantity;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建用户
     */
    private String createUser;
    /**
     * 创建人
     */
    private LocalDateTime createTime;
}
