package com.rocogz.merchant.dto.report;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * @author zhangmin
 * 统计报表汇总：汇总报表 查看发放清单列表 搜索参数
 */
@Setter
@Getter
public class SearchReportGrantBillListParamDto {

    /**
     * 发放主体编号【精确匹配】,在Admin处理时，会将 issuingBodeCode 放入issuingBodyCodeList，并设置issuingBodeCode=null
     */
    private String issuingBodeCode;

    /**
     * 发放主体BodyCode
     */
    private List<String> issuingBodyCodeList;

    /**
     * 发放主体登录账号用户名 【精确匹配】
     */
    private String grantUserName;

    /**
     * 团队编号列表 【精确匹配】
     */
    private List<String> teamCodeList;

    /**
     * 权益编号：合作客户编号或代理商产品编号 【精确匹配】
     */
    private String customerOrAgentProductCode;

    /**
     * 权益名称：合作客户编号或代理商产品名keyword 【模糊匹配】
     */
    private String customerOrAgentProductNameKeyword;

    /**
     * 发放目标客户手机号：即收券人手机号 【精确匹配】
     */
    private String grantMobile;

    /**
     * 发放开始日期 格式：YYYY-MM-dd
     */
    private String grantStartDate;

    /**
     * 发放结束日期 格式：YYYY-MM-dd
     */
    private String grantEndDate;

    /**
     * 页大小
     */
    private Integer limit = 20;

    /**
     * 当前页
     */
    private Integer page = 1;

    /**
     * 是否本级和下级查询
     */
    private Boolean selfSubQuery;


    /**
     * 是否需要导出
     */
    private Boolean export = Boolean.FALSE;


    public String getGrantEndDate() {
        if (StringUtils.isBlank(this.grantEndDate)) {
            return null;
        }

        return this.grantEndDate.trim() + " 23:59:59";
    }

    public String getCustomerOrAgentProductNameKeywordLike() {
        if(StringUtils.isBlank(customerOrAgentProductNameKeyword)) {
            return null;
        }

        return "%" + customerOrAgentProductNameKeyword + "%";
    }

}
