package com.rocogz.merchant.dto.scm;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * c端加油订单创建分销订单的请求实体类
 * @author djt
 * @date 2022/4/13
 */
@Data
@Accessors(chain = true)
public class ScmConsumerOilCreateOrderReq {

    @NotBlank
    private String customerProductCode;

    @NotBlank
    private String issuingBodyCode;

    @NotBlank
    private String businessNo;

    @NotNull
    private BigDecimal payAmount;

    @NotBlank
    private String rechargeMobile;

    /**
     *结算单元
     */
    private String settleUnit;

    /**
     * 发放主体所属合作客户编号
     */
    private String customerCode;

    /**
     * 发放主体代理商编号
     */
    private String agentCode;

    /**
     * 发放主体性质
     */
    private String issuingNature;
}
