package com.rocogz.merchant.dto.scm.order;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @author zhangmin
 */
@Setter
@Getter
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class SettleReceiptItem {

    /**
     * 收款单号
     */
    private String receiptCode;

    /**
     * 收款单上的 收款到账日期
     */
    private LocalDate receiptDate;

    /**
     * 需要结算总金额
     */
    private BigDecimal totalAmount;

    /**
     * 收款明细编号
     */
    private String receiptItemCode;

    /**
     * 合作客户产品编号
     */
    private String customerProductCode;

}