package com.rocogz.merchant.client.store;


import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.rocogz.merchant.pager.Sort;
import lombok.Getter;
import lombok.Setter;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zhangmin
 * 搜索 门店参数
 */
@Setter
@Getter
public class SearchStoreParamDto {

    private Integer limit = 10;

    private Integer page = 1;

    private String keyword;

    /**
     * 门店编号
     */
    private String code;

    private List<String> areaCodeList;

    /**
     * 行业编号
     */
    private String industryCode;
    private List<String> industryCodeList;


    /**
     * 门店类型
     */
    private String type;
    private List<String> typeList;

    /**
     * 营业状态
     */
    private String businessStatus;

    private String provinceCode;
    private String cityCode;
    private String districtCode;
    private String streetCode;

    private List<String> statusList;

    private List<String> issuingBodyList;

    /**
     * 排序字段列表
     */
    private List<Sort.Order> sortList;

    public String getLikeKeyWord() {
        if(StringUtils.isBlank(keyword)){
            return null;
        }
        return  "%" + keyword.trim() + "%";
    }


    public void addSortProperty(Sort.Order order) {
        if(sortList == null) {
            sortList = new ArrayList<>();
        }
        sortList.add(order);
    }


    public void addAscProperty(String columnName) {
        this.addSortProperty(Sort.Order.build(Sort.Direction.ASC,columnName));
    }

    public void addDescPropery(String columnName) {
        this.addSortProperty(Sort.Order.build(Sort.Direction.DESC,columnName));
    }
}
