package com.rocogz.merchant.entity.channel.product;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;

/**
 * @Description: 通道产品实体类
 * @date：2021/11/23
 * @author：huangdeyi
 */
@Data
@Accessors(chain = true)
@TableName("merchant_channel_product")
public class MerchantChannelProduct extends IdEntity {

    private static final long serialVersionUID = 858081814927213126L;

    /**
    * 产品编号(序列号,自动生成)
    */
    private String code;
    
    /**
    * 通道产品名称
    */
    private String name;
    
    /**
    * 产品类别
    */
    private String productCategory;
    
    /**
    * 第三方平台编号
     * @see MerchantThirdPlatform#platformCode
    */
    private String platformCode;
    
    /**
    * 关联的扣款主体编号
     * @see MerchantDeductSubject#code
    */
    private String deductSubjectCode;
    
    /**
    * 第三方产品编号(对应上游的系统的产品编号)
    */
    private String thirdProductCode;
    
    /**
    * 第三方产品名称
    */
    private String thirdProductName;
    
    /**
    * 市场价
    */
    private BigDecimal marketPrice;
    
    /**
    * 采购价
    */
    private BigDecimal purchasePrice;
    
    /**
    * 状态
    */
    private String status;
    
    /**
    * 产品说明
    */
    private String description;

    /**
     * 过期操作类型
     */
    private String orderDelayReissue;

    /**
    * 创建时间
    */
    private LocalDateTime createTime;
    
    /**
    * 创建人
    */
    private Integer createUser;
    
    /**
    * 更新时间
    */
    private LocalDateTime updateTime;
    
    /**
    * 更新人
    */
    private Integer updateUser;

    /**
     * 创建人姓名
     */
    @TableField(exist = false)
    private String createUserName;

    /**
     * 更新人姓名
     */
    @TableField(exist = false)
    private String updateUserName;

    /**
     * 产品类别名称
     */
    @TableField(exist = false)
    private String productCategoryName;

    /**
     * 第三方平台名称
     */
    @TableField(exist = false)
    private String platformName;

    /**
     * 扣款主体名称
     */
    @TableField(exist = false)
    private String deductSubjectName;

    /**
     * 第三方平台信息
     */
    @TableField(exist = false)
    private MerchantThirdPlatform thirdPlatform;

    /**
     * 扣款主体信息
     */
    @TableField(exist = false)
    private MerchantDeductSubject deductSubject;

    /**
     * 获取扣款主体的参数配置Map
     * @return
     */
    public Map<String, String> getDeductSubjectParamMap() {
        if (deductSubject == null) {
            return new HashMap<>(8);
        }
        return deductSubject.deductSubjectParamsToMap();
    }
}