package com.rocogz.merchant.entity.rocomall;

import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * <p>
 * ROCO商城商品基本信息表
 * </p>
 *
 * @author yinshihao
 * @since 2020-09-24
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantRocoMallGoodsSpecialPrice extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 商品编码
     */
    private String goodsCode;

    /**
     * 用户角色(用字典值表示,针对不同角色可以设置不用价格)
     */
    private String userRole;

    /**
     * 手机号(当指定为个人角色时需要填写)
     */
    private String phone;

    /**
     * 指定价(针对不同用户指定价格,没有指定就用该商品的sale_price)
     */
    private BigDecimal appointPrice;

}
