package com.rocogz.merchant.entity.scmWarehouse;

import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <dl>
 * <dd>Description:分销中主体商品的出库仓库配置 </dd>
 * <dd>@date: 2022/03/09</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantScmBodyGoodsWarehouseRule extends UserTimeEntity {

    private static final long serialVersionUID=1L;
    /**
     * 主体code
     */
    private String issuingBodyCode;

    /**
     * 合作客户产品编号
     */
    private String customerGoodsCode;

    /**
     * 出库的仓库编号 选择要出库的商品和出库仓库之后，出库仓库和出库的商品编码就已经确定好了。
     */
    private String whCode;
    /**
     * 出库的仓库商品编号
     */
    private String whGoodsCode;

    /**
     * 状态:(OPEN/LOCK)
     */
    private String status;

}
