package com.rocogz.merchant.request.customer.goods;

import com.rocogz.merchant.enumerate.ProductSortField;
import com.rocogz.merchant.pager.Sort;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * B端代理人 搜索产品 请求参数
 * @author zhangmin
 * @date 2021/2/3
 */
@Data
@Accessors(chain = true)
public class BAgentSearchGoodsReq {

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 合作客户编号
     */
    private String customerCode;


    /**
     * 代理商编号
     */
    private String agentCode;

    /**
     * 产品状态
     */
    private String status;

    /**
     * 产品类型
     */
    private String goodsType;

    /**
     * 产品类型 列表 需求：如果商品类型下没有商品就不返回，用这个传递一个集合过来
     */
    private List<String> goodsTypeList;

    private BigDecimal minCostPrice;

    private BigDecimal maxCostPrice;

    private BigDecimal minMarketPrice;

    private BigDecimal maxMarketPrice;

    private ProductSortField sortProperty = ProductSortField.DISCOUNT;

    private Sort.Direction direction = Sort.Direction.ASC;

    /**
     * 页大小
     */
    private Integer limit=10 ;

    /**
     * 当前页
     */
    private Integer page=1 ;
}
