package com.rocogz.merchant.entity.storeservice;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 商户服务项目车型价格上架历史
 * </p>
 *
 * @author liangyongtong
 * @since 2020-04-12
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MerchantStoreServiceTolistLog extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 商户服务项目编码
     */
    private String serviceCode;

    /**
     * 结算商结算价历史
     */
    private String settlePrice;

    /**
     * 商户结算价历史
     */
    private String storePrice;

    /**
     * 市场结算价历史
     */
    private String marketPrice;

    /**
     * 上架人
     */
    private String tolistUser;

    /**
     * 上架时间
     */
    private LocalDateTime tolistTime;

}
