package com.rocogz.merchant.response.goods;

import com.rocogz.merchant.enumerate.GoodsTypeEnum;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author djt
 * @date 2021/7/20
 */
@Data
public class BaseGoodsResp {

    private Integer id;

    /**
     * 产品名称
     */
    private String name;

    /**
     * 产品编号
     */
    private String code;

    /**
     * 产品面值
     */
    private BigDecimal faceValue;

    /**
     * 产品状态
     */
    private String status;

    /**
     * 产品内容
     */
    private String content;

    /**
     * 产品类型
     */
    private String goodsType;

    /**
     * 平台产品编号
     */
    private String platformGoodsCode;

    /**
     * 平台产品市场价
     */
    private String platformFaceValue;


    /**
     * 代理商编号
     */
    private String agentCode;

    /**
     * 代理商产品编号
     */
    private String agentGoodsCode;

    /**
     * 代理商产品市场价
     */
    private String agentFaceValue;

    /**
     * 代理商采购价
     */
    private String agentPurchasePrice;

    /**
     * 代理商采购结算单价
     */
    private BigDecimal agentPurchaseSettlePrice;

    /**
     * 合作客户编号
     */
    private String customerCode;


    /**
     * 合作客户产品额度扣减单价
     */
    private String customerSettlePrice;

    /**
     * 合作客户产品额度扣减单价
     */
    private String customerPurchaseSettlePrice;

    /**
     * 产品类型
     */
    private GoodsTypeEnum goodsNature;

    /**
     * 有效期
     */
    private Integer useValidity;


    /**
     * 主体可发放产品上配置的仓库
     */
    private String whCode;

    /**
     * 平台产品上是否启用库存表记
     */
    private String whetherNeedStock;

    /**
     * 发放主体产品状态
     */
    private String issuingBodyGoodsStatus;






}
