package com.rocogz.merchant.dto.scm;

import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 后台管理服务商备付金备付金扣款记录响应
 * @author djt
 * @date 2021/9/22
 */
@Data
public class AdminDownOrderPayLogResp {

    private Integer id;

    /**
     * 订单类型
     */
    private String orderType;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 下单业务号
     */
    private String businessCode;

    /**
     * 服务商产品编号
     */
    private String agentProductCode;

    /**
     * 服务商产品类型
     */
    private String agentProductName;

    /**
     * 服务商产品市场价
     */
    private BigDecimal agentMarketPrice;

    /**
     * 发放总张数(发放产品数量)
     */
    private Integer quantity;

    /**
     * 服务商备付金支付金额
     */
    private BigDecimal agentPayPrice;

    /**
     * 发放主体额度支付金额
     */
    private BigDecimal issuingBodyPayPrice;

    /**
     * 服务商备付金支付金额
     */
    private BigDecimal agentRefundPrice;

    /**
     * 发放主体额度支付金额
     */
    private BigDecimal issuingBodyRefundPrice;

    /**
     * 订单状态
     */
    private String orderStatus;

    /**
     * 服务商备付金支付时间
     */
    private LocalDateTime agentPayTime;

    /**
     * 服务商备付金退款时间
     */
    private LocalDateTime agentRefundTime;

    /**
     * 订单交易类型
     */
    private String tradeType;

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 发放主体简称
     */
    private String issuingBodyAbbreviation;

}
