package com.rocogz.merchant.entity.customer.goods;

import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 合作客户产品信息表
 * </p>
 *
 * @author djt
 * @since 2020-12-16
 */
@Data
public class MerchantCustomerGoods extends IdEntity {


    /**
     * 合作客户产品编号
     */
    private String code;

    /**
     * 产品名称
     */
    private String name;

    /**
     * 平台产品编码
     */
    private String goodsCode;

    /**
     * 代理商产品编号
     */
    private String agentGoodsCode;

    /**
     * 合作商户编号
     */
    private String customerCode;

    /**
     * 代理商编号
     */
    private String agentCode;

    /**
     * 客户类别
     */
    private String customerCategory;

    /**
     * 采购方式
     */
    private String purchaseWay;

    /**
     * 客户专享价   20210601 改为 额度扣减单价
     */
    private BigDecimal settlePrice;


    /**
     * 采购结算单价
     */
    private BigDecimal purchaseSettlePrice;

    /**
     * 市场价
     */
    private BigDecimal marketPrice;

    /**
     * 渠道价
     */
    private BigDecimal channelPrice;

    /**
     * 产品说明
     */
    private String introduce;

    /**
     * 上下架状态
     */
    private String status;

    /**
     * 创建人id
     */
    private Integer createUser;

    /**
     * 创建人名称
     */
    private String createUserName;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新人id
     */
    private Integer updateUser;

    /**
     * 更新人名称
     */
    private String updateUserName;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 小程序显示名称
     */
    private String appletDisplayName;

    /**
     * 备注
     */
    private String remark;
}
