package com.rocogz.merchant.entity.store;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 商户账号登录日志
 * </p>
 *
 * @author zhangminn
 * @since 2020-09-07
 */
@Setter @Getter
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MerchantStoreLoginLog extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 商户账号
     */
    private String accountCode;

    /**
     * 门店编号
     */
    private String storeCode;

    /**
     * 微信昵称
     */
    private String nickName;

    /**
     * openId
     */
    private String openId;

    /**
     * 登录Ip
     */
    private String loginIp;


    /**
     * 登录地点经纬度
     */
    @TableField("login_latlng")
    private String loginLatLng;

    /**
     * 登录省份
     */
    private String loginProvince;

    /**
     * 登录城市
     */
    private String loginCity;

    /**
     * 登录区县
     **/
    private String loginDistrict;

    /**
     * 登录地点详细地址
     */
    private String loginAddress;


    /**
     * 登录时间
     */
    private LocalDateTime loginTime;


}
