package com.rocogz.merchant.entity.type;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;

/**
 * <p>
 * 商户服务-商户类型表
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-04-07
 */
@TableName("merchant_type")
@Data
public class MerchantType extends UserTimeEntity {

    private static final long serialVersionUID = -1923225693430959378L;
    /**
     * 自营类型
     */
    public static final String SELF_BUSINESS= "MT2020062600001";

    /**
     * 商户类型编码
     */
    private String code;

    /**
     * 所属行业编码
     */
    private String industryCode;

    /**
     * 所属行业名称
     */
    @TableField(exist = false)
    private String industryName;

    /**
     * 商户类型名称:4S店 自营油站
     */
    private String name;

    /**
     * 状态
     */
    private String status;
}
