package com.rocogz.merchant.dto.scmWarehouse.stock.single;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description:单商品操作的Item </dd>
 * <dd>@date: 2022/03/17</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class ScmGoodsStockSingleItemBase {

    /**
     * 操作人
     */
    @NotBlank
    private String operator;

    /**
     * 业务单号:
     * 可能的编号:清单编号
     */
    @NotBlank
    private String bizNo;

    /**
     * 下游订单编号
     */
    private String downOrderCode;

    /**
     * 产品编号
     * 1.下单的时候的产品编号，这个当时为了返查库存流时用，但积分兑换产品它的下单产品编号并不再下游订单中
     * 所以返查数据流时出错，现在调整为只根据bizNo来进行查询
     */
    private String goodsCode;
    /**
     * 数量
     */
    @Min(1)
    @NotNull
    private Integer qty;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;
}
