package com.rocogz.merchant.entity.scm;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.merchant.constant.Constant;
import com.rocogz.merchant.dto.scm.ScmSendDto;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 供应链发放信息
 * </p>
 *
 * @author liangyongtong
 * @since 2021-03-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantScmInformation extends UserTimeEntity {

    private static final long serialVersionUID = 6368647649044093889L;

    /**
     * 订单号
     */
    private String orderCode;

    /**
     * 发放主体编号
     */
    private String sourceCode;

    /**
     * 发放主体性质,即发放主体类型：是代理商还是合作客户
     * @see Constant.DictData#SOURCE_NATURE_AGENT
     */
    private String sourceNature;

    /**
     * 发放客户：合作客户编号或代理商编号
     */
    private String sourceCustomer;

    /**
     * 发放主体：代理商编号
     */
    private String agentCode;

    /**
     * 发放主体：合作客户编号
     */
    private String customerCode;

    /**
     * 扣款 合作客户编号或代理商编号
     * 发放申请单创建人主体对应的合作客户编号或代理商编号
     */
    private String dedutionCustomerCode;

    /**
     * 发放时间
     */
    private LocalDateTime grantTime;

    /**
     * 发放用户手机号：即发放主体 登录账号的手机号
     */
    private String createUserMobile;


    /**
     * 发放目标平台,微信小程序的servicePlatformCode
     * @see com.rocogz.syy.infrastructure.entity.app.config.BasicWxMiniAppConfig#servicePlatformCode
     */
    private String targetPlatform;

    /**
     * 发放目标小程序ID
     */
    private String targetMiniAppid;

    /**
     * 有效期规则编码,也就是发放规则编号
     */
    private String validityRules;

    /**
     * 发放方式:
     * (1)后台批量发放
     * /接口/
     *(2)手工发放:包括B端礼赠申请单
     *(3)积分兑换
     * @see Constant.DictData#GRANT_WAY_BATCH
     */
    private String grantWay;

    /**
     * 发放来源平台：SYY
     */
    private String grantPlatform;

    /**
     * 原始发放张数: 清单中的quantity
     * @see com.rocogz.syy.equity.entity.batchDistributionCouponApply.EquityBatchDistributionCouponApplyDetail#getQuantity
     */
    private Integer quantity;

    /**
     * 如果是直充油卡产品，则表示单位面额,1张券输入的自定义面额
     * 如果是非直充：则是单个客户产品/服务商产品 的市场价
     * @see ScmSendDto#unitFaceValue
     */
    private BigDecimal unitFaceValue;

    /**
     * C端壳牌加油,则是选择的优惠抵扣金额
     * @see ScmSendDto#discountAmount
     */
    private BigDecimal discountAmount;

    /**
     * 申请单号
     * @see com.rocogz.syy.equity.entity.batchDistributionCouponApply.EquityBatchDistributionCouponApply#applyNo
     */
    private String applyNo;

    /**
     * 下单业务号：即清单编号:接口发放/后台批量发放
     * @see com.rocogz.syy.equity.entity.batchDistributionCouponApply.EquityBatchDistributionCouponApplyDetail#code
     */
    private String businessCode;

    /**
     * 领取有效期：生效日期
     */
    private LocalDateTime effectiveDate;

    /**
     * 领取有效期：失效日期
     */
    private LocalDateTime invalidDate;

    /**
     * 领取有效期状态：(未生效, 已生效、已过期)
     * @see  Constant.DictValidityStatus#INEFFECTIVE
     */
    private String receiveValidityStatus;

    /**
     * 已延期次数
     */
    private Integer  deferCnt;

    /**
     * 领取验证规则
     */
    private String receiveRules;

    /**
     * 发放业务性质:正常发放/业务验证
     * @see com.rocogz.syy.equity.entity.batchDistributionCouponApply.EquityBatchDistributionCouponApply#nature
     */
    private String grantNature;

    /**
     * 发放主体团队编码
     * @see basic_team_info.team_code
     */
    private String teamCode;

    /**
     * 服务商备付金扣款账户
     */
    private  String deductionAgentCode;

    /**
     * 发放主体的：所属结算单位
     */
    private String belongSettlementUnit;


    //-----------传输---------
    //下游详情要用
    /**
     * 发放客户名称
     */
    @TableField(exist = false)
    private String sourceCustomerName;

    //下游订单类型,给权益基础服务使用
    @TableField(exist = false)
    private String orderType;

}
