package com.rocogz.merchant.dto.bAgent.goods;

import com.rocogz.merchant.entity.goods.MerchantGoods;
import com.rocogz.merchant.entity.product.MerchantProductType;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

import static com.rocogz.merchant.constant.Constant.DictData.GOODS_NATURE_PLATFORM_MEAL;
import static com.rocogz.merchant.constant.Constant.DictData.GOODS_NATURE_SUPPLIER_MEAL;

/**
 * <dl>
 * <dd>Description:B端代理人商品 </dd>
 * <dd>@date: 2021/05/24</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Setter
@Getter
@Accessors(chain = true)
public class BAgentProductResponseDto {
    /**
     * 产品名称
     */
    private String goodsName;

    //代理人勾选中的 客户产品编号/代理商产品编号/平台产品编码(如果是套餐子项)
    private String goodsCode;

    /**
     * 平台产品编码
     */
    private String platformGoodsCode;

    /**
     * 勾选中的产品的 产品类型
     *
     * @see MerchantGoods#goodsType
     * @see Constant.DictData#PRODUCT_TYPE_OIL_CARD_DIGITAL_YES
     */
    private String goodsType;

    /**
     * 产品类型编号
     * @see MerchantGoods#goodsTypeCode
     */
    private String productTypeCode;

    /**
     * 产品类型名称
     * @see  MerchantProductType#name
     */
    private String productTypeName;

    /**
     * 是否虚拟商品(Y:是,N:否)
     */
    private String invented;

    /**
     * 图片
     */
    private String listView;

    /**
     * 卡券左上角标签
     */
    private String cardCouponLeftCornerLabel;

    /**
     * 卡券金额下方注释内容 可配置区域
     */
    private String cardCouponNotes;

    /**
     * 使用说明，因套餐项取得使用说明是基础商品信息里的。基础信息中的introduce是个富文本，不太适合
     * 暂时对于套餐项不赋值。
     */
    private String introduce;

    /**
     * 成本价
     * 非套餐子项：MerchantAgentGoods#getPurchasePrice,MerchantAgentGoods#purchasePrice
     * 套餐子项：不返回
     */
    private BigDecimal costPrice;

    /**
     * 市场价
     * 非套餐子项：合作客户/服务商的市场价
     * 套餐子项：MerchantGoodsMeal#marketPrice
     */
    private BigDecimal marketPrice;

    /**
     * 产品内容,套餐的内含卡券，例如：
     *      50元代驾券        x1
     *      100元电子加油券   x3
     *      100元加油抵扣券   x4
     */
    private String goodsContent;

    /**
     * 一句话亮点，也就是列表中的权益说明
     * @see MerchantGoods#saleLightPoint
     */
    private String saleLightPoint;

    /**
     * 有效期，列表中有个有效期
     * @see MerchantGoods#useValidity
     */
    private Integer useValidity;

    /**
     * 左侧中部显示文案
     * @see MerchantGoods#leftMiddleDisplayDescribe
     */
    private String leftMiddleDisplayDescribe;

    /**
     * 产品性质 单品，平台订单套餐，供应商定制套餐
     */
    private String goodsNature;

    /**
     * 品牌名称
     */
    private String brandName;

    /**
     * 套餐项商品的组成数量 例如 代驾券2张
     */
    private Integer composeNum;


    /**
     * 套餐子项商品
     */
    List<BAgentProductResponseDto> suitItems ;


}
