package com.rocogz.merchant.dto.scm;

import com.rocogz.merchant.constant.Constant;
import com.rocogz.merchant.entity.goods.MerchantGoodsValidityRule;
import com.rocogz.merchant.entity.scm.MerchantScmInformation;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 发放产品订单信息参数
 * @author：liangyongtong
 * @since：2021/3/9
 */
@Data
@Accessors(chain = true)
public class ScmSendDto implements Serializable {
    private static final long serialVersionUID = 5154035306572354255L;
    /**
     * 发放主体
     */
    private String sourceCode;

    /**
     * 发放主体性质
     */
    private String sourceNature;

    /**
     * 发放客户:合作客户
     */
    private String sourceCustomer;

    /**
     * 发放主体：代理商编号
     */
    private String agentCode;

    /**
     * 发放主体：合作客户编号
     */
    private String customerCode;

    /**
     * 扣款账户
     */
    private String dedutionCustomerCode;

    /**
     * 发放时间
     */
    private LocalDateTime grantTime;

    /**
     * 发放目标平台
     */
    private String targetPlatform;

    /**
     * 发放目标小程序ID
     */
    private String targetMiniAppid;

    /**
     * 有效期规则编码
     */
    private String validityRules;

    /**
     * 发放方式:后台批量发放/接口/手工发放
     */
    private String grantWay;


    /**
     * 发放来源平台
     */
    private String grantPlatform;

    /**
     * 申请单号
     * @see MerchantScmInformation#applyNo
     */
    private String applyNo;

    /**
     * 下单业务号,清单编号:接口发放/后台批量发放
     * @see MerchantScmInformation#businessCode
     */
    private String businessCode;

    /**
     *领取有效期： 生效日期
     */
    private LocalDateTime receiveEffectiveDate;

    /**
     * 领取有效期：失效日期
     */
    private LocalDateTime receiveInvalidDate;

    /**
     * 领取验证规则
     */
    private String receiveRules;

    /**
     * 发放业务性质:正常发放/业务验证
     */
    private String grantNature;

    /**
     * 创建人:发放主体登录账号 用户名
     */
    private String createUser;

    /**
     * 发放用户手机号：即发放主体登录账号的手机号
     */
    private String createUserMobile;

    /**
     * 发放总张数
     */
    private Integer quantity;

    /**
     * 如果是直充产品， 则表示单位面额,1张券输入的自定义面额
     * 如果是非直充：   则是单个客户产品/服务商产品 的市场价
     * 如果是C_OIL订单 则此字段表示输入的充值金额rechargeAmount
     */
    private BigDecimal unitFaceValue;

    /**
     * C端壳牌加油,则是选择的优惠抵扣金额
     */
    private BigDecimal discountAmount = BigDecimal.ZERO;

    /**
     * 合作客户产品编码
     */
    private String customerProductCode;

    /**
     * 代理商产品编码
     */
    private String agentProductCode;

    /**
     * 平台产品编码
     */
    private String productCode;

    /**
     * 产品使用规则:原基准券编号
     */
    private String couponCode;

    /**
     * 发放会员手机号,收用户券的会员手机号
     */
    private String grantMobile;

    /**
     * 发放会员证件信息
     */
    private String grantIdno;

    /**
     * 发放会员证件类型
     */
    private String grantIdtype;

    /**
     * 发放会员车牌
     */
    private String grantLicence;

    /**
     * 发放会员车架号
     */
    private String vinNo;

    /**
     * 发放会员姓名
     */
    private String grantUsername;

    /**
     * 发放会员保单号
     */
    private String policyNumber;

    /**
     * 团队编码
     */
    private String teamCode;

    /**
     * 备付金扣减时点
     */
    private String dedutionTimePoint;

    /**
     * 订单类型
     * @see Constant.DictData#SCM_ORDER_TYPE_SYS
     */
    private String orderType;

    /**
     * 额度支付金额
     */
    private BigDecimal quotaPrice = BigDecimal.ZERO;

    /**
     * 现在支付金额
     */
    private BigDecimal cashPrice = BigDecimal.ZERO;

    /**
     * 客户备付金扣减金额: 如果是纯现金支付的,客户服务商和服务商的备付金都是0
     */
    private BigDecimal coverPrice = BigDecimal.ZERO;

    /**
     * 服务商备付金扣款账户
     */
    private  String  deductionAgentCode;

    /**
     * 发放主体的：所属结算单位
     */
    private String  belongSettlementUnit;


    /**
     * 为哪个上游订单补发【上游订单号】
     */
    private String reissueFor;

    /**
     * 补发金额
     */
    private BigDecimal reissuedAmount;


    /**
     * 仓库编号，如果发放的产品有 库存管理需求，则传入此字段
     */
    private String warehouseCode;


    // ===  壳牌加油 积分兑换商品订单 相关字段如下 ==
    /**
     * 壳牌油站编号 【壳牌加油】
     * @see QiaoPaiOilStationInfo#stationCode
     */
    private String oilStation;

    /**
     * 壳牌油站名 【壳牌加油】
     */
    private String oilStationName;

    /**
     * 壳牌油枪编号 【壳牌加油】
     */
    private String oilGun;

    /**
     * 壳牌油枪名 【壳牌加油】
     */
    private String oilGunName;

    /**
     * 壳牌油品、油号的编号：例如：95【壳牌加油】
     */
    private String oilNo;

    /**
     * 壳牌油品/油号名称：例如：95#【壳牌加油】
     */
    private String oilNoName;

    /**
     * 壳牌油品单价【壳牌加油】
     */
    private BigDecimal oilUnitPrice;

    // ===  壳牌加油 积分兑换商品订单 end ==


    /**
     * 使用有效期规则 ,如果传入了规则则 使用传入的， 否则供应链端自己查询
     */
    private MerchantGoodsValidityRule  validityRule;


    /**
     * 是否需要支付合作客户备付金
     * @return true:需要支付 ,false:不需要支付
     */
    public boolean needCustomerPay() {
        return !StringUtils.isEmpty(this.dedutionCustomerCode);
    }

    //获取发放的目标产品，如果客户产品不为空，则返回客户产品，否则返回服务产品
    public String getGrantProductCode() {
        if(!StringUtils.isEmpty(customerProductCode)) {
            return customerProductCode;
        }
        return agentProductCode;
    }




}
