package com.rocogz.merchant.dto.scm.caoc;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * @author 陈煜敏
 * @Description: 曹操专车-获取订单详情返回实体dto
 * @Package com.rocogz.merchant.dto.scm.caoc
 * @date 2022/08/04 15:48
 * @Copyright © 广州大诚若谷信息科技有限公司
 */
@Data
public class CaocOrderDetailDto {

    /**
     * 活动ID
     */
    @JsonProperty("activityId")
    private String activityId;

    /**
     * 曹操用户ID
     */
    @JsonProperty("customerId")
    private String customerId;

    /**
     * 外部用户ID
     */
    @JsonProperty("externalCustomer")
    private String externalCustomerId;

    /**
     * 用户名称
     */
    @JsonProperty("customerName")
    private String customerName;

    /**
     * 用户手机号码
     */
    @JsonProperty("customerPhone")
    private String customerPhone;

    /**
     * 实际使用时间
     */
    @JsonProperty("usedTime")
    private LocalDateTime usedTime;

    /**
     * 用户实际支付金额，单位：分
     */
    @JsonProperty("userPaymentAmou")
    private Integer userPaymentAmount;

    /**
     * 行程总金额，单位：分
     */
    @JsonProperty("travelTotalAmou")
    private Integer travelTotalAmount;

    /**
     * 行程开始时间
     */
    @JsonProperty("travelStartTime")
    private LocalDateTime travelStartTime;

    /**
     * 行程结束时间
     */
    @JsonProperty("travelEndTime")
    private LocalDateTime travelEndTime;

    /**
     * 行程订单ID
     */
    @JsonProperty("travelOrderId")
    private String travelOrderId;

    /**
     * 实际出发地
     */
    @JsonProperty("realStartingPlac")
    private String realStartingPlace;

    /**
     * 实际目的地
     */
    @JsonProperty("realEndingPlace")
    private String realEndingPlace;

    /**
     * 实际行驶里程，单位：公里
     */
    @JsonProperty("realMileage")
    private Double realMileage;

}
