package com.rocogz.merchant.entity.scmWarehouse;

import com.rocogz.merchant.constant.ScmWarehouseConstant;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description:分销的调拨申请单 </dd>
 * <dd>@date: 2022/03/09</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantScmStockAllocateApply  extends UserTimeEntity {
    /**
     * 申请单编号
     */
    private String code;

    /**
     * 出库仓库编号
     */
    private String outWhCode;

    /**
     * 出库仓库类型：仓库表上的type
     */
    private String outWhType;

    /**
     * 入库仓库编号
     */
    private String inWhCode;

    /**
     * 入库仓库类型：仓库表上的type
     */
    private String inWhType;
    /**
     * 入库商品编号
     */
    private String inGoodsCode;

    /**
     * 入库产品名称
     */
    private String inGoodsName;

    /**
     * 状态:待提交/处理中/失败/已完成/......
     * @see ScmWarehouseConstant.DictAllocateStatusType#TYPE_CODE
     */
    private String status;

    /**
     * 出库商品编号
     */
    private String outGoodsCode;

    /**
     * 出库产品名称
     */
    private String outGoodsName;

    /**
     * 完成时间
     */
    private LocalDateTime successTime;

    /**
     * 点击调拨的提交人
     */
    private String submitUser;

    /**
     * 调拨的提交时间
     */
    private LocalDateTime submitTime;

    /**
     * 错误信息
     */
    private String errorDesc;

    /**
     * 操作的数量
     */
    private Integer quantity ;

    /**
     * 备注
     */
    private String remark;


}
