package com.rocogz.merchant.entity.customer.goods;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description:发放主体的合作客户商品信息 </dd>
 * <dd>@date: 2021/11/10</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
public class MerchantIssuingBodyCustomerGoods extends IdEntity {

    /**
     * 发放主体编码
     */
    private String issuingBodyCode;

    /**
     * 合作客户Code
     */
    private String customerCode;

    /**
     * 合作客户产品编码
     */
    private String customerGoodsCode;

    /**
     * 平台产品编号
     */
    @TableField(exist = false)
    private String platformGoodsCode;

    /**
     * 仓库
     */
    private String whCode;

    /**
     * 创建人id
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新人id
     */
    private String updateUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;



}
