package com.rocogz.merchant.entity.scmWarehouse;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.merchant.constant.Constant;
import com.rocogz.merchant.constant.ScmWarehouseConstant;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <dl>
 * <dd>Description:库存流水表 </dd>
 * <dd>@date: 2022/03/09</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantScmStockFlow  extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 流水号，通过发号器生成
     */
    private String flowCode;

    /**
     * 业务单号:清单编号/兑换订单编号，调拨申请单号
     */
    private String bizNo;

    /**
     * 发放主体Code，场景
     * 1.冻结库存时,要知道发放主体编号，到主体商品配置信息去找到要出的商品
     */
    private String issuingBodyCode;

    /**
     * 下游订单编号
     */
    private String downOrderCode;

    /**
     * 产品单号要扣减库存的原商品编号，比如清单中的发放产品编号
     */
    private String bizGoodsCode;

    /**
     * 类型：出库/入库
     * @see ScmWarehouseConstant.DictScmStockFlowType#TYPE_CODE
     */
    private String type;

    /**
     * 数据库流类型：名称
     */
    @TableField(exist = false)
    private String typeName;

    /**
     * 完成状态 Y/N
     * @see ScmWarehouseConstant.DictScmStockFlowEndStatusType#TYPE_CODE
     */
    private String endStatus;

    /**
     * 库存流的完结状态
     */
    @TableField(exist = false)
    private String endStatusName;

    /**
     * 仓库编号
     */
    private String whCode;

    /**
     * 仓库名称
     */
    @TableField(exist = false)
    private String whName;

    /**
     * 仓库类型
     */
    @TableField(exist = false)
    private String whType;

    /**
     * 仓库类型
     */
    @TableField(exist = false)
    private String whTypeName;

    /**
     * 实际操作中的仓库产品编号
     */
    private String whGoodsCode;

    /**
     * 实际操作中的仓库产品名称
     */
    @TableField(exist = false)
    private String whGoodsName;

    /**
     * 当前这个业务单所处阶段（对于同一个业务单阶段是覆盖形式的）:
     * 当前阶段:冻结库存，占用库存，取消库存，扣减出库，
     * 可售增加，可售减少
     * @see ScmWarehouseConstant.DictScmStockFlowStageType#TYPE_CODE
     */
    private String stage;

    /**
     * 阶段名称
     */
    @TableField(exist = false)
    private String stageName;

    /**
     * 操作的数量
     */
    private Integer quantity;

    /**
     * 备注
     */
    private String remark;

}
