package com.rocogz.merchant.client.scm;

import com.rocogz.merchant.entity.scm.MerchantScmOrderInformation;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 订单支付结果
 * @author：liangyongtong
 * @since：2021/4/8
 */
@Data
@Accessors(chain = true)
public class ReqScmAccount implements Serializable {
    /**
     * 订单编码
     */
    private String orderCode;

    /**
     * 明细订单编号
     */
    private String orderItemCode;

    /**
     * 支付流水号
     */
    private String coverFlowCode;

    /**
     * 支付状态
     */
    private String payStatus;
    /**
     * 支付结果提示
     */
    private String payReason;

    /**
     * 支付次数
     */
    private int payRetryNum;

    /**
     * 请求耗时
     */
    private String elapsedSeconds;
    /**
     * 请求开始时间
     */
    private LocalDateTime sTime;
    /**
     * 请求结束时间
     */
    private LocalDateTime eTime;

    /**
     * 请求报文
     */
    private String reqText;

    /**
     * 响应报文
     */
    private String resText;

    /**
     * 合作客户备付金扣减时点
     * @see MerchantScmOrderInformation#dedutionTimePoint
     */
    private String dedutionTimePoint;

    /**
     * 发放客户
     */
    private String sourceCustomer;

    /**
     * 扣款账户
     */
    private String dedutionCustomerCode;

    /**
     * 更新备付金额度发放状态
     */
    private String coverGrantStatus;

    /**
     * 更新服务商备付金发放金额状态
     */
    private String agentGrantStatus;

    /**
     * 仅更新状态相关
     */
    private boolean onlyUpdateStatus;
}
