package com.rocogz.merchant.dto.scm;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 订单核销状态，更新状态
 * @author：liangyongtong
 * @since：2021/3/18
 */
@Data
@Accessors(chain = true)
public class WriteOffDto implements Serializable {

    /**
     * 子订单编码
     */
    private String orderItemCode;

    /**
     * 套餐明细订单号
     */
    private String comboOrderItemCode;

    /**
     * 第三方券号,例如鼎聚返回鼎powerNo
     */
    private String thirdBusinessCode;

    /**
     * ROCO车服用户券号,如果仅传入用户券编号，则根据上游订单发放的用户券编号来更新核销状态（C端壳牌加油使用抵扣券后核销关联的上游订单）
     */
    private String rocoUserCouponCode;
}
