package com.rocogz.merchant.dto.scm.correction;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Getter;
import lombok.Setter;

import java.time.LocalDateTime;
import java.util.List;


/**
 * @author zhangmin
 */
@Setter
@Getter
@JsonIgnoreProperties(ignoreUnknown = true)
public class CorrectScmOrderDto {

    /**
     * 修正业务批次号
     */
    private String batchNo;

    /**
     * 主体编号
     */
    private String issuingCode;

    /**
     * 调整前客户编号
     */
    private String oldCustomerCode;

    /**
     * 调整后客户编号
     */
    private String newCustomerCode;

    /**
     * 调整后客户简称
     */
    private String newCustomerAbbreviation;


    /**
     * 主体客户产品dto
     */
    private List<CorrectCustomerProductDto> productList;
}
