package com.rocogz.merchant.dto.scm.qiaopai.resp;

import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @author 尹世豪
 * @Description: 油价信息
 * @Package com.rocoinfo.service.remote.dto.qiaopai.resp
 * @date 2022/7/28 19:32
 * @Copyright © 广州大诚若谷信息科技有限公司
 */
@Data
@Accessors(chain = true)
public class QiaoPaiOilPrice {
    /**
     * 油枪编号列表([5a,5b,5c], 必有)
     */
    private List<String> oilGunNoList;
    /**
     * 油品名称(非必有)
     */
    private String goodsName;
    /**
     * 油品编码(必有)
     * 92	92#
     * 95	95#
     * 98	98#
     * SVP95	SVP95#
     * SVP98	SVP98#
     */
    private String goodsCode;
    /**
     * 油号类别(非必有)
     * GASOLINE	汽油
     * DIESEL_OIL	柴油
     * NATURAL_GAS	天然气
     */
    private String goodsGroupType;
    /**
     * 油品单价(必有)
     */
    private QiaoPaiGoodsPrice goodsPrice;
}
