package com.rocogz.merchant.entity.scm;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.rocogz.merchant.constant.Constant;
import com.rocogz.merchant.entity.agent.goods.MerchantAgentGoods;
import com.rocogz.merchant.entity.customer.goods.MerchantCustomerGoods;
import com.rocogz.merchant.entity.goods.MerchantGoods;
import com.rocogz.merchant.entity.goods.MerchantGoodsMeal;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * <p>
 * 产品信息
 * </p>
 *
 * @author liangyongtong
 * @since 2021-03-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantScmProductInformation extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 订单号
     */
    private String orderCode;

    /**
     * 合作客户产品编码
     * @see MerchantCustomerGoods#code
     */
    private String customerProductCode;

    /**
     * 合作客户产品名称
     */
    private String customerProductName;

    /**
     * 客户产品类型：HAVE（门店自营）、PLATFORM（平台）
     * @see MerchantCustomerGoods#customerGoodsType
     * @see Constant.General#MERCHANT_CUSTOMER_GOODS_HAVE
     */
    private String customerProductType;

    /**
     * 合作客户产品采购价格：用来扣减额度
     * @see MerchantCustomerGoods#settlePrice
     */
    private BigDecimal customerPurchasePrice;

    /**
     * 合作客户产品市场价/面额
     * @see MerchantCustomerGoods#marketPrice
     */
    private BigDecimal customerMarketPrice;

    /**
     * 合作客户结算采购价：用来扣减备付金
     * @see MerchantCustomerGoods#purchaseSettlePrice
     */
    private BigDecimal customerPurchaseSettlePrice;

    /**
     * 代理商产品编码
     * 如果是 发放的服务项目客户产品则 没有服务商产品
     */
    private String agentProductCode;

    /**
     * 代理商产品名称
     */
    private String agentProductName;

    /**
     * 代理商产品采购价格: 服务商产品额度扣减单价
     * @see MerchantAgentGoods#purchasePrice
     */
    private BigDecimal agentPurchasePrice;

    /**
     * 代理商产品市场价/面额
     * @see MerchantAgentGoods#marketPrice
     */
    private BigDecimal agentMarketPrice;

    /**
     * 代理商结算采购价
     * @see MerchantAgentGoods#purchaseSettlePrice
     */
    private BigDecimal agentPurchaseSettlePrice;

    /**
     * 平台产品编码
     */
    private String productCode;

    /**
     * 平台产品名称
     */
    private String productName;

    /**
     * 产品性质:单品,供应商定制套餐、平台定制套餐
     * @see Constant.DictData#GOODS_NATURE_ITEM
     * @see MerchantGoods#goodsNature
     */
    private String productNature;

    /**
     * 平台供应商产品编码
     */
    @TableField(exist = false)
    private String thirdProductCode;

    /**
     * 平台采购价格
     * @see MerchantGoods#costPrice
     */
    private BigDecimal purchasePrice;

    /**
     * 平台市场价/面额
     * @see MerchantGoods#marketPrice
     */
    private BigDecimal marketPrice;

    /**
     * 产品类别：加油代金券、电子油卡券直充、积分券
     * @see Constant.DictData#PRODUCT_TYPE_OIL_CARD_DIGITAL_YES
     * @see MerchantGoods#goodsType
     */
    private String productType;

    /**
     * 产品使用规则:原基准券编号
     */
    private String couponCode;

    /**
     * 平台产品的品牌编号
     * @see MerchantGoods#brandCode
     */
    private String brandCode;

    //不存在表中，列表上需要显示
    /**
     * 产品类型名字
     */
    @TableField(exist = false)
    private String goodsTypeName;

    /**
     * 使用有效期-结束日期 (天)
     * @see MerchantGoods#useValidity
     */
    @TableField(exist = false)
    private Integer useValidity;

    /**
     * 是否需要调用权益系统发放用户券接口 (Y:是, N:否)
     */
    @TableField(exist = false)
    private String whetherNeedIssueCoupon;



    //获取客户或服务商的市场价格
    public BigDecimal getCustomerOrAgentMarketPrice() {
        if(StringUtils.isNotBlank(customerProductCode)) {
            return customerMarketPrice;
        }

        return agentMarketPrice;
    }



}
