package com.rocogz.merchant.entity.scm.record;

import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * 中石油加油券使用记录
 * @author djt
 * @date 2022/4/18
 */
@Data
@Accessors(chain = true)
public class MerchantScmCnpcUsedRecord extends IdEntity {

    /**
     *  第三方订单号
     */
    private String tradeNo;

    /**
     * 分销上游订单号
     */
    private String orderId;

    /**
     * 核销地点
     */
    private String stationNo;

    /**
     * 使用的金额
     */
    private String usedAmount;

    /**
     * 使用时间
     */
    private String usedTime;

    /**
     * 券状态
     */
    private String couponStatus;

    /**
     * 订单状态
     */
    private String state;

    /**
     * 核销信息字符串
     */
    private String response;

    /**
     *  创建时间
     */
    private LocalDateTime createTime;


}
