package com.rocogz.merchant.dto.scmWarehouse.warehouse;

import com.rocogz.merchant.constant.ScmWarehouseConstant;
import lombok.Data;

import java.util.List;

/**
 * <dl>
 * <dd>Description:列表等一些的查询请求 </dd>
 * <dd>@date: 2022/03/12</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
public class ScmWarehouseSearchReq {

    /**
     * 仓库名称
     */
    private String whName;

    /**
     * 仓库编码
     */
    private String whCode;

    /**
     * 仓库编码集合
     * 已知场景：调拨过滤仓库使用
     */
    private List<String> whCodeList;

    /**
     * 仓库类型
     * @see ScmWarehouseConstant.DictScmWarehouseType#TYPE_CODE
     */
    private String whType;

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 合作客户编号
     */
    private String customerCode;

    /**
     * 代理商编号
     */
    private String agentCode;

    /**
     * 仓库状态 OPEN/LOCK
     */
    private String status;

    /**
     * True 表示不分页时，分页条件不启作用
     */
    private Boolean noPage = Boolean.FALSE;

    /**
     * 分页
     */
    private Integer limit = 20;
    /**
     * 当前第几页
     */
    private Integer page = 1;

}
